function File = cell_cropper(Settings,File,ROI);
% CELL_CROPPER crops all images from the stack, i.e., the gel fluorescence image, 
% the reference image (after trypsinization) and phase contrast image. Images are cropped so that the
% shift between the fluorescence image and the corresponding reference image is smaller than 0.5 pixels.
% Cropped images are stored in the folder CROPPEDDATA
% 
% INPUTS:
% SETTINGS, ROI
%      
% FILE is structure that contains at least the fields
%       NAME: the names of the files        
%       NFiles: Numbers of files
%       ROI: output from draw_boundary that sets the limits of the ROI

%   Md. Mydul Islam Miku 2017 2018     
%   Robert Steward 2011
%   Xavier Trepat 05/02/2007
%   Raimon Sunyer 09/26/2006
%	Iva Marija Tolic-Norrelykke 2002;


% Define the ROI. This contains the region with the cell of interest.

cd('C:\code\Trac_MSM_Code\Data');

i1 = ROI(1).i1;
i2 = ROI(1).i2;
i22 = min(ROI(1).i2, ROI(1).i1 + 1024 -1) ; %limit the image to 1024 x 1024
j1 = ROI(1).j1 ;
j2 = ROI(1).j2 ;
j22 = min(ROI(1).j2, ROI(1).j1 + 1024 -1) ;

% Major loop that goes through each fluoresnce image of the stack.
for i=1:File.NFiles.Fluorescence,
    disp(['Computing global shift of ',num2str(i), ' of ', num2str(File.NFiles.Fluorescence), ' images']);
      
            % open fluorescence, trypsin, and phase images
             im1 = imread(File.Name(1).Trypsin);
             im2 = imread(File.Name(i).Fluorescence); 
             imPhase = imread(File.Name(i).PC);

    im1 = double(im1);
    im2 = double(im2);
    
    im1a=im1(i1:i2,j1:j2);
    im2a=im2(i1:i2,j1:j2);
    
    im1b=im1(i1:i22,j1:j22); % smaller image for xcorr2
    im2b=im2(i1:i22,j1:j22);
    
    
    [x, y, shx, shy, pkh] =   disp_on_blocks_fast( im1b, ... % reference image /trypsin/
                                                   im2b, ... % measurement image
                                                   size(im1b,1), ... % resolution of the PIV grid
                                                   0, ... % overlap between blocks
                                                   0, ... % padding for the PIV, usually 0
                                                   'cosn', ... % window for FFT calculation
                                                   '2DCentroid', ... % method to compute max of cross-correlation
                                                   0, ... % threshold of center of mass calculation
                                                   3, ... % Size of the window
                                                   0 ... % dont iterate
                                                    );    
    
    disp(['     ... shift from trypsin is ','(',num2str(shx),',',num2str(shy),') pixels... ']);
    
    shx=round(shx);
    shy=round(shy);
    
        
    % crop trypsin    
    im1b = im1(i1:i2,j1:j2);
    File.Name(1).CropTrypsin=[File.pathname,'/Croppeddata', '/crop','_', 'Trypsin', '_', num2str(1),'.tif'];
    %save cropped trypsin as tif files
    imwrite(uint16(im1b), File.Name(1).CropTrypsin,'tif', 'compression', 'none');
    
    % crop fluorescence
    im2b = im2(max(1,i1+shy) : min(size(im2,1),i2+shy), max(1,j1+shx) : min(size(im2,2),j2+shx));
    File.Name(i).CropFluorescence=[File.pathname,'/Croppeddata', '/crop','_', 'Fluorescence', '_', num2str(i),'.tif'];
    %save cropped fluorescence image as tif file
    imwrite(uint16(im2b), File.Name(i).CropFluorescence,'tif', 'compression', 'none');
    
    % crop phase contrast   
     imPhase = imPhase(max(1,i1+shy) : min(size(imPhase,1),i2+shy), max(1,j1+shx) : min(size(imPhase,2),j2+shx));
     imPhase = double(imPhase);  
     File.Name(i).CropPC=[File.pathname,'/Croppeddata', '/crop','_', 'PC', '_', num2str(i),'.tif'];
     imwrite(uint16(imPhase), File.Name(i).CropPC, 'tif', 'compression', 'none');
  
        
    end
    
end

